/**
 * WordPress dependencies
 */
const {
	Path,
	SVG
} = wp.components;

export const otterIcon = () => {
	return (
		<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 29 32" width="20" height="20" className="otter-icon">
			<Path d="M19.831 7.877c0.001-0.003 0.001-0.005 0.001-0.009s-0-0.006-0.001-0.009l0 0c-0.047-0.081-0.092-0.164-0.132-0.247l-0.057-0.115c-0.277-0.498-0.381-0.99-1.033-1.064h-0.045c-0.001 0-0.002 0-0.003 0-0.486 0-0.883 0.382-0.908 0.862l-0 0.002c0.674 0.126 1.252 0.278 1.813 0.468l-0.092-0.027 0.283 0.096 0.147 0.053s0.028 0 0.028-0.011z" />
			<Path d="M23.982 13.574c-0.008-2.41-0.14-4.778-0.39-7.112l0.026 0.299 0.070-0.019c0.459-0.139 0.787-0.558 0.787-1.053 0-0.479-0.307-0.887-0.735-1.037l-0.008-0.002h-0.026c-0.479-0.164-0.874-0.468-1.149-0.861l-0.005-0.007c-2.7-3.96-8.252-3.781-8.252-3.781s-5.55-0.179-8.25 3.781c-0.28 0.401-0.676 0.704-1.14 0.862l-0.016 0.005c-0.441 0.148-0.754 0.557-0.754 1.040 0 0.009 0 0.017 0 0.026l-0-0.001c-0 0.010-0.001 0.022-0.001 0.034 0 0.493 0.335 0.907 0.789 1.029l0.007 0.002 0.045 0.011c-0.224 2.034-0.356 4.403-0.364 6.801l-0 0.012s-9.493 13.012-1.277 17.515c4.733 2.431 6.881-0.769 6.881-0.769s1.397-1.661-1.784-3.355v-4.609c0.006-0.344 0.282-0.621 0.625-0.628h1.212v-0.59c0-0.275 0.223-0.498 0.498-0.498v0h1.665c0.274 0.001 0.496 0.224 0.496 0.498 0 0 0 0 0 0v0 0.59h2.721v-0.59c0-0.275 0.223-0.498 0.498-0.498v0h1.665c0.271 0.005 0.49 0.226 0.49 0.498 0 0 0 0 0 0v0 0.59h1.209c0 0 0 0 0 0 0.349 0 0.633 0.28 0.639 0.627v4.584c-3.193 1.703-1.784 3.355-1.784 3.355s2.148 3.193 6.879 0.769c8.222-4.503-1.269-17.515-1.269-17.515zM22.586 10.261c-0.097 1.461-0.67 2.772-1.563 3.797l0.007-0.008c-1.703 2.010-4.407 3.249-6.721 4.432v0c-2.325-1.177-5.026-2.416-6.736-4.432-0.883-1.019-1.455-2.329-1.555-3.769l-0.001-0.020c-0.126-2.22 0.583-5.929 3.044-6.74 2.416-0.788 3.947 1.288 4.494 2.227 0.152 0.258 0.429 0.428 0.745 0.428s0.593-0.17 0.743-0.424l0.002-0.004c0.551-0.932 2.080-3.008 4.494-2.22 2.474 0.805 3.174 4.513 3.046 6.734z" />
			<Path d="M19.463 10.087h-0.028c-0.192 0.026-0.121 0.251-0.047 0.356 0.254 0.349 0.407 0.787 0.407 1.26 0 0.006-0 0.012-0 0.018v-0.001c-0.001 0.469-0.255 0.878-0.633 1.1l-0.006 0.003c-0.739 0.426-1.377-0.145-2.054-0.398-0.72-0.269-1.552-0.434-2.42-0.455l-0.009-0v-1.033c1.020-0.233 1.894-0.76 2.551-1.486l0.004-0.004c0.151-0.163 0.244-0.383 0.244-0.623 0-0.316-0.159-0.595-0.402-0.76l-0.003-0.002c-0.768-0.551-1.728-0.881-2.764-0.881-1.054 0-2.029 0.341-2.819 0.92l0.013-0.009c-0.224 0.166-0.367 0.429-0.367 0.726 0 0.226 0.083 0.433 0.221 0.591l-0.001-0.001c0.665 0.751 1.55 1.295 2.553 1.53l0.033 0.007v1.050c-0.742 0.021-1.448 0.14-2.118 0.343l0.057-0.015c-0.341 0.103-0.631 0.219-0.908 0.358l0.033-0.015c-0.519 0.26-1.037 0.436-1.58 0.121-0.371-0.213-0.617-0.607-0.617-1.058 0-0.002 0-0.004 0-0.007v0c0-0.002 0-0.004 0-0.007 0-0.47 0.153-0.905 0.411-1.257l-0.004 0.006c0.047-0.068 0.089-0.17 0.026-0.241s-0.189 0-0.27 0.030c-0.189 0.099-0.348 0.227-0.479 0.381l-0.002 0.002c-0.245 0.296-0.394 0.679-0.394 1.097 0 0.004 0 0.007 0 0.011v-0.001c0.008 0.706 0.393 1.321 0.964 1.651l0.009 0.005c0.296 0.178 0.654 0.283 1.036 0.283 0.364 0 0.706-0.095 1.001-0.263l-0.010 0.005c0.877-0.461 1.917-0.731 3.019-0.731 0.069 0 0.137 0.001 0.206 0.003l-0.010-0h0.030c1.277 0 2.382 0.266 3.266 0.775 0.27 0.159 0.594 0.253 0.94 0.253 0.001 0 0.002 0 0.003 0h-0c0.355-0.002 0.688-0.098 0.974-0.265l-0.009 0.005c0.606-0.357 1.007-1.007 1.007-1.75 0-0.001 0-0.003 0-0.004v0c0.001-0.026 0.002-0.056 0.002-0.086 0-0.625-0.34-1.171-0.846-1.462l-0.008-0.004c-0.056-0.040-0.125-0.065-0.199-0.070l-0.001-0zM13.101 8.831c-0.238 0.213-0.468 0.581-0.832 0.345-0.061-0.041-0.114-0.086-0.161-0.136l-0-0c-0.063-0.063-0.101-0.15-0.101-0.247 0-0.133 0.074-0.248 0.182-0.308l0.002-0.001c0.594-0.309 1.203-0.543 1.884-0.49-0.324 0.281-0.649 0.56-0.973 0.837z" />
			<Path d="M15.89 13.578c-0.367 0.483-0.941 0.792-1.588 0.792s-1.221-0.309-1.585-0.787l-0.004-0.005c-0.064-0.103-0.177-0.171-0.306-0.171-0.199 0-0.36 0.161-0.36 0.36 0 0.091 0.034 0.174 0.090 0.238l-0-0c0.499 0.659 1.283 1.080 2.164 1.080s1.665-0.421 2.159-1.073l0.005-0.007c0.043-0.059 0.068-0.132 0.068-0.212 0-0.116-0.055-0.22-0.14-0.286l-0.001-0.001c-0.059-0.045-0.134-0.072-0.215-0.072-0.117 0-0.221 0.056-0.286 0.143l-0.001 0.001z" />
			<Path d="M18.507 11.707c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z" />
			<Path d="M17.389 11.049c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z" />
			<Path d="M10.798 11.707c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z" />
			<Path d="M11.918 11.049c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z" />
			<Path d="M8.773 7.877c-0.001-0.003-0.002-0.005-0.002-0.009s0.001-0.006 0.002-0.009l-0 0c0.047-0.081 0.089-0.164 0.132-0.247 0.019-0.038 0.036-0.079 0.057-0.115 0.275-0.498 0.379-0.99 1.033-1.064h0.045c0 0 0.001 0 0.001 0 0.487 0 0.884 0.382 0.91 0.862l0 0.002c-0.678 0.124-1.261 0.277-1.827 0.468l0.092-0.027-0.275 0.096-0.1 0.036-0.045 0.017s-0.023 0-0.023-0.011z" />
		</SVG>
	);
};

export const authorIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M17.348 20.657v-0.135c1.029-0.471 1.758-1.446 1.916-2.563 0.434-0.157 0.739-0.576 0.739-1.051 0-0.408-0.221-0.774-0.562-0.969 0.036-0.111 0.065-0.223 0.087-0.335 0.182-0.901-0.025-1.822-0.583-2.592-0.548-0.758-1.373-1.281-2.321-1.473-0.255-0.051-0.515-0.077-0.773-0.077-0.813 0-1.607 0.262-2.234 0.739-0.646 0.49-1.088 1.187-1.244 1.962-0.118 0.587-0.070 1.193 0.139 1.762-0.355 0.191-0.59 0.566-0.59 0.985 0 0.481 0.31 0.901 0.751 1.055 0.163 1.144 0.916 2.128 1.978 2.587v0.106c-2.207 0.5-3.729 2.151-3.729 4.079v0.515h10.153v-0.515c0-1.929-1.522-3.58-3.729-4.080zM15.853 12.492c0.189 0 0.381 0.019 0.569 0.057 0.693 0.14 1.293 0.519 1.689 1.066 0.369 0.511 0.518 1.111 0.423 1.701-0.507-0.237-1.173-0.487-1.874-0.583-1.318-0.18-1.339-0.241-1.417-0.469l-0.252-0.728-0.579 0.512c-0.062 0.054-0.528 0.464-1.066 0.91-0.015-0.198-0.002-0.396 0.037-0.593 0.219-1.086 1.257-1.873 2.469-1.873zM13.67 16.025c0.361-0.292 0.718-0.594 0.977-0.816 0.358 0.323 0.916 0.414 1.874 0.545 0.65 0.089 1.287 0.349 1.748 0.578v1.161c0 1.268-1.031 2.299-2.299 2.299s-2.299-1.031-2.299-2.299v-1.468zM15.682 20.81c0.213 0.019 0.425 0.017 0.635-0.006v0.318l-0.318 0.177-0.317-0.176v-0.313zM12.006 24.22c0.237-1.154 1.25-2.113 2.646-2.501v0.010l1.346 0.748 1.35-0.748v-0.010c1.396 0.388 2.409 1.348 2.646 2.502l-7.987-0zM21.076 27.499h-10.153c-0.307 0-0.556-0.249-0.556-0.556s0.249-0.556 0.556-0.556h10.153c0.307 0 0.556 0.249 0.556 0.556s-0.249 0.556-0.556 0.556zM28.112 3.393h-9.422v-1.689c0-0.832-0.677-1.509-1.509-1.509h-2.363c-0.832 0-1.509 0.677-1.509 1.509v1.689h-9.422c-0.832 0-1.509 0.677-1.509 1.509v25.395c0 0.832 0.677 1.509 1.509 1.509h24.225c0.832 0 1.509-0.677 1.509-1.509v-25.395c-0-0.832-0.677-1.509-1.509-1.509zM14.421 1.703c0-0.219 0.178-0.397 0.397-0.397h2.363c0.219 0 0.397 0.178 0.397 0.397v5.083c0 0.219-0.178 0.397-0.397 0.397h-2.363c-0.219 0-0.397-0.178-0.397-0.397v-5.083zM28.509 30.297c0 0.219-0.178 0.397-0.397 0.397h-24.225c-0.219 0-0.397-0.178-0.397-0.397v-25.395c0-0.219 0.178-0.397 0.397-0.397h9.422v2.282c0 0.832 0.677 1.509 1.509 1.509h2.363c0.832 0 1.509-0.677 1.509-1.509v-2.282h9.422c0.219 0 0.397 0.178 0.397 0.397v25.395z" />
		</SVG>
	);
};

export const buttonsIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M30.457 11.777h-28.914c-0.829 0-1.503 0.674-1.503 1.503v5.606c0 0.829 0.674 1.503 1.503 1.503h28.914c0.829 0 1.503-0.674 1.503-1.503v-5.606c-0-0.829-0.674-1.503-1.503-1.503zM30.84 18.886c0 0.211-0.172 0.383-0.383 0.383h-28.914c-0.211 0-0.383-0.172-0.383-0.383v-5.606c0-0.211 0.172-0.383 0.383-0.383h28.914c0.211 0 0.383 0.172 0.383 0.383v5.606zM4.67 15.133c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95 0.95-0.425 0.95-0.95c0-0.525-0.425-0.95-0.95-0.95zM7.947 15.133c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95c0.525 0 0.95-0.425 0.95-0.95s-0.425-0.95-0.95-0.95zM11.224 15.133c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95c0.525 0 0.95-0.425 0.95-0.95s-0.425-0.95-0.95-0.95zM27.871 15.523h-11.386c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h11.386c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56zM30.457 23.388h-28.914c-0.829 0-1.503 0.674-1.503 1.503v5.606c0 0.829 0.674 1.503 1.503 1.503h28.914c0.829 0 1.503-0.674 1.503-1.503v-5.606c-0-0.829-0.674-1.503-1.503-1.503zM30.84 30.497c0 0.211-0.172 0.383-0.383 0.383h-28.914c-0.211 0-0.383-0.172-0.383-0.383v-5.606c0-0.211 0.172-0.383 0.383-0.383h28.914c0.211 0 0.383 0.172 0.383 0.383v5.606zM4.67 26.744c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95 0.95-0.425 0.95-0.95c0-0.525-0.425-0.95-0.95-0.95zM7.947 26.744c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95c0.525 0 0.95-0.425 0.95-0.95s-0.425-0.95-0.95-0.95zM11.224 26.744c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95c0.525 0 0.95-0.425 0.95-0.95s-0.425-0.95-0.95-0.95zM27.871 27.134h-11.386c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h11.386c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56zM30.457 0h-28.914c-0.829 0-1.503 0.674-1.503 1.503v5.606c0 0.829 0.674 1.503 1.503 1.503h28.914c0.829 0 1.503-0.674 1.503-1.503v-5.606c0-0.829-0.674-1.503-1.503-1.503zM30.84 7.109c0 0.211-0.172 0.383-0.383 0.383h-28.914c-0.211 0-0.383-0.172-0.383-0.383v-5.606c0-0.211 0.172-0.383 0.383-0.383h28.914c0.211 0 0.383 0.172 0.383 0.383v5.606zM5.62 4.306c0 0.525-0.425 0.95-0.95 0.95s-0.95-0.425-0.95-0.95c0-0.525 0.425-0.95 0.95-0.95s0.95 0.425 0.95 0.95zM7.947 3.356c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95c0.525 0 0.95-0.425 0.95-0.95s-0.425-0.95-0.95-0.95zM11.224 3.356c-0.525 0-0.95 0.425-0.95 0.95s0.425 0.95 0.95 0.95c0.525 0 0.95-0.425 0.95-0.95s-0.425-0.95-0.95-0.95zM27.871 3.746h-11.386c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h11.386c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56z" />
		</SVG>
	);
};

export const columnsIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M30.584 0.099h-29.068c-0.781 0-1.417 0.635-1.417 1.416v29.068c0 0.781 0.635 1.416 1.417 1.416h29.068c0.781 0 1.416-0.635 1.416-1.416v-29.068c0-0.781-0.635-1.416-1.416-1.416zM1.515 1.219h29.068c0.163 0 0.296 0.133 0.296 0.296v3.476h-29.661v-3.476c0-0.163 0.133-0.296 0.296-0.296zM30.584 30.88h-29.068c-0.163 0-0.296-0.133-0.296-0.296v-24.472h29.661v24.472c0 0.163-0.133 0.296-0.296 0.296zM26.999 20.461h-21.062c-0.838 0-1.52 0.682-1.52 1.52v5.601c0 0.838 0.682 1.52 1.52 1.52h21.062c0.838 0 1.52-0.682 1.52-1.52v-5.601c0-0.838-0.682-1.52-1.52-1.52zM27.399 27.582c0 0.221-0.18 0.4-0.4 0.4h-21.062c-0.221 0-0.4-0.18-0.4-0.4v-5.601c0-0.221 0.179-0.4 0.4-0.4h21.062c0.221 0 0.4 0.179 0.4 0.4v5.601zM5.937 16.247h5.432c0.838 0 1.52-0.682 1.52-1.52v-5.432c0-0.838-0.682-1.52-1.52-1.52h-5.432c-0.838 0-1.52 0.682-1.52 1.52v5.432c0 0.838 0.682 1.52 1.52 1.52zM5.537 9.294c0-0.221 0.179-0.4 0.4-0.4h5.432c0.221 0 0.4 0.179 0.4 0.4v5.432c0 0.221-0.18 0.4-0.4 0.4h-5.432c-0.221 0-0.4-0.18-0.4-0.4v-5.432zM27.959 17.714h-22.982c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h22.982c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56zM27.959 14.793h-12.696c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h12.696c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56zM27.959 11.433h-12.696c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h12.696c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56zM27.959 8.072h-12.696c-0.309 0-0.56 0.251-0.56 0.56s0.251 0.56 0.56 0.56h12.696c0.309 0 0.56-0.251 0.56-0.56s-0.251-0.56-0.56-0.56zM4.543 3.051c0 0.497-0.403 0.9-0.9 0.9s-0.9-0.403-0.9-0.9c0-0.497 0.403-0.9 0.9-0.9s0.9 0.403 0.9 0.9zM7.384 3.051c0 0.497-0.403 0.9-0.9 0.9s-0.9-0.403-0.9-0.9c0-0.497 0.403-0.9 0.9-0.9s0.9 0.403 0.9 0.9zM10.224 3.051c0 0.497-0.403 0.9-0.9 0.9s-0.9-0.403-0.9-0.9c0-0.497 0.403-0.9 0.9-0.9s0.9 0.403 0.9 0.9z" />
		</SVG>
	);
};

export const columnIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M31.276 3.351h-14.587l-3.23-3.028c-0.103-0.097-0.239-0.15-0.38-0.15h-12.354c-0.307 0-0.556 0.249-0.556 0.556v30.697c0 0.307 0.249 0.556 0.556 0.556h30.551c0.307 0 0.556-0.249 0.556-0.556v-27.518c0-0.307-0.249-0.556-0.556-0.556zM1.281 1.286h11.578l3.23 3.028c0.103 0.097 0.239 0.15 0.38 0.15h14.25v3.013h-29.439v-6.191zM30.719 30.87h-29.439v-22.281h29.439v22.281z" />
		</SVG>
	);
};

export const headingIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M30.958 13.988h-0.64c-0.572-5.298-4.029-9.744-8.764-11.73h5.439v0.555c0 0.309 0.25 0.559 0.559 0.559h2.23c0.309 0 0.559-0.25 0.559-0.559v-2.229c0-0.309-0.25-0.559-0.559-0.559h-2.23c-0.309 0-0.559 0.25-0.559 0.559v0.555h-9.319v-0.555c0-0.309-0.25-0.559-0.559-0.559h-2.23c-0.309 0-0.559 0.25-0.559 0.559v0.555h-9.319v-0.555c0-0.309-0.25-0.559-0.559-0.559h-2.229c-0.309 0-0.559 0.25-0.559 0.559v2.229c0 0.309 0.25 0.559 0.559 0.559h2.229c0.309 0 0.559-0.25 0.559-0.559v-0.555h5.439c-4.735 1.987-8.191 6.432-8.764 11.73h-0.64c-0.309 0-0.559 0.25-0.559 0.559v2.229c0 0.309 0.25 0.559 0.559 0.559h2.23c0.309 0 0.559-0.25 0.559-0.559v-2.229c0-0.309-0.25-0.559-0.559-0.559h-0.464c0.709-6.044 5.49-10.86 11.518-11.621v0.446c0 0.309 0.25 0.559 0.559 0.559h2.23c0.309 0 0.559-0.25 0.559-0.559v-0.446c6.028 0.761 10.809 5.578 11.518 11.621h-0.464c-0.309 0-0.559 0.25-0.559 0.559v2.23c0 0.309 0.25 0.559 0.559 0.559h2.23c0.309 0 0.559-0.25 0.559-0.559v-2.229c0-0.309-0.25-0.559-0.559-0.559zM29.223 2.253h-1.111v-1.111h1.111v1.111zM2.777 1.142h1.111v1.111h-1.111v-1.111zM2.712 15.608v0.609h-1.111v-0.973c0.001-0.046 0.002-0.092 0.003-0.138h1.108v0.501zM16 1.142c0.186 0 0.371 0.005 0.555 0.012v1.099h-1.111v-1.099c0.184-0.007 0.37-0.012 0.556-0.012zM30.399 15.25v0.967h-1.111v-1.111h1.107c0.002 0.048 0.003 0.096 0.004 0.144zM16.512 4.461c-0.089-0.204-0.29-0.336-0.513-0.336s-0.424 0.132-0.513 0.336l-7.287 16.694c-0.058 0.134-0.062 0.285-0.011 0.421l0.009 0.023c0.059 0.157 0.186 0.279 0.345 0.333 1.743 0.585 2.914 2.213 2.914 4.052 0 0.766-0.206 1.518-0.595 2.175-0.012 0.020-0.022 0.041-0.032 0.063-0.063 0.091-0.101 0.201-0.101 0.32v2.832c0 0.307 0.248 0.557 0.555 0.559l9.42 0.068c0.001 0 0.003 0 0.004 0 0.307 0 0.557-0.248 0.559-0.555 0.002-0.309-0.246-0.561-0.555-0.563l-8.865-0.064v-1.405h8.654c0.234 0 0.443-0.145 0.524-0.364l0.153-0.41c0.059-0.158 0.043-0.335-0.043-0.48-0.389-0.657-0.595-1.409-0.595-2.174 0-1.838 1.171-3.467 2.914-4.052 0.16-0.054 0.287-0.176 0.346-0.334l0.009-0.023c0.051-0.136 0.047-0.287-0.011-0.42l-7.287-16.694zM16 20.028c0.619 0 1.122 0.503 1.122 1.122s-0.504 1.122-1.122 1.122c-0.619 0-1.122-0.503-1.122-1.122s0.503-1.122 1.122-1.122zM19.424 25.983c0 0.802 0.179 1.591 0.52 2.31h-7.887c0.341-0.719 0.52-1.509 0.52-2.31 0-2.121-1.235-4.020-3.127-4.894l5.991-13.726v11.616c-0.966 0.249-1.682 1.128-1.682 2.17 0 1.236 1.005 2.241 2.241 2.241s2.241-1.005 2.241-2.241c0-1.043-0.716-1.921-1.682-2.17v-11.616l5.991 13.726c-1.892 0.874-3.127 2.773-3.127 4.894z" />
		</SVG>
	);
};

export const faIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M30.424 0.171h-28.847c-0.775 0-1.406 0.631-1.406 1.406v28.848c0 0.775 0.631 1.406 1.406 1.406h28.847c0.775 0 1.406-0.631 1.406-1.406v-28.848c0-0.775-0.631-1.406-1.406-1.406zM1.576 1.282h28.847c0.162 0 0.294 0.132 0.294 0.294v3.45h-29.435v-3.45c0-0.162 0.132-0.294 0.294-0.294zM30.424 30.718h-28.847c-0.162 0-0.294-0.132-0.294-0.294v-24.286h29.435v24.286c0 0.162-0.132 0.294-0.294 0.294zM3.688 3.994c0.493 0 0.893-0.4 0.893-0.893s-0.4-0.893-0.893-0.893-0.893 0.4-0.893 0.893c0 0.493 0.4 0.893 0.893 0.893zM6.507 3.994c0.493 0 0.893-0.4 0.893-0.893s-0.4-0.893-0.893-0.893-0.893 0.4-0.893 0.893c0 0.493 0.4 0.893 0.893 0.893zM9.326 3.994c0.493 0 0.893-0.4 0.893-0.893s-0.4-0.893-0.893-0.893-0.893 0.4-0.893 0.893c0 0.493 0.4 0.893 0.893 0.893zM20.662 19.394l3.855-3.758c0.152-0.148 0.206-0.369 0.141-0.57s-0.239-0.348-0.449-0.378l-5.328-0.774-2.383-4.828c-0.094-0.19-0.287-0.31-0.498-0.31s-0.405 0.12-0.498 0.31l-2.383 4.828-5.328 0.774c-0.209 0.030-0.383 0.177-0.449 0.378s-0.011 0.422 0.141 0.57l3.855 3.758-0.91 5.307c-0.036 0.209 0.050 0.419 0.221 0.544s0.398 0.141 0.585 0.042l4.766-2.506 4.766 2.506c0.081 0.043 0.17 0.064 0.259 0.064 0.115 0 0.23-0.036 0.327-0.106 0.171-0.124 0.257-0.335 0.221-0.544l-0.91-5.307zM16.259 21.661c-0.162-0.085-0.355-0.085-0.517 0l-4.027 2.117 0.769-4.485c0.031-0.18-0.029-0.364-0.16-0.492l-3.258-3.176 4.503-0.654c0.181-0.026 0.338-0.14 0.418-0.304l2.014-4.080 2.014 4.080c0.081 0.164 0.238 0.278 0.419 0.304l4.503 0.654-3.258 3.176c-0.131 0.128-0.191 0.312-0.16 0.492l0.769 4.485-4.027-2.117zM16 25.179c-0.307 0-0.556 0.249-0.556 0.556v1.887c0 0.307 0.249 0.556 0.556 0.556s0.556-0.249 0.556-0.556v-1.887c0-0.307-0.249-0.556-0.556-0.556zM25.319 20.446l-1.794-0.583c-0.293-0.095-0.606 0.065-0.7 0.357s0.065 0.606 0.357 0.7l1.794 0.583c0.057 0.019 0.115 0.027 0.172 0.027 0.234 0 0.452-0.149 0.529-0.384 0.095-0.292-0.065-0.606-0.357-0.7zM20.218 12.197c0.099 0.072 0.213 0.106 0.326 0.106 0.172 0 0.341-0.079 0.45-0.229l1.109-1.526c0.18-0.248 0.125-0.596-0.123-0.776s-0.596-0.125-0.776 0.123l-1.109 1.526c-0.18 0.248-0.125 0.596 0.123 0.776zM11.006 12.075c0.109 0.15 0.278 0.229 0.45 0.229 0.113 0 0.228-0.034 0.326-0.106 0.248-0.18 0.303-0.528 0.123-0.776l-1.109-1.526c-0.18-0.248-0.528-0.303-0.776-0.123s-0.303 0.528-0.123 0.776l1.109 1.526zM8.475 19.863l-1.794 0.583c-0.292 0.095-0.452 0.408-0.357 0.7 0.076 0.235 0.294 0.384 0.529 0.384 0.057 0 0.115-0.009 0.172-0.027l1.794-0.583c0.292-0.095 0.452-0.408 0.357-0.7s-0.408-0.452-0.7-0.357z" />
		</SVG>
	);
};

export const sharingIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M6.348 13.197c-0.308 0-0.557 0.249-0.557 0.557s0.249 0.557 0.557 0.557c0.495 0 1.655 0.598 1.655 1.759 0 0.308 0.249 0.557 0.557 0.557s0.557-0.249 0.557-0.557c0-1.886-1.803-2.873-2.769-2.873zM25.842 3.161c0.495 0 1.655 0.598 1.655 1.759 0 0.308 0.249 0.557 0.557 0.557s0.557-0.249 0.557-0.557c0-1.886-1.802-2.873-2.769-2.873-0.308 0-0.557 0.249-0.557 0.557s0.249 0.557 0.557 0.557zM25.742 22.433c-0.826 0-1.641 0.22-2.359 0.636-0.567 0.328-1.040 0.758-1.41 1.252l-11.344-6.569c0.069-0.174 0.13-0.353 0.179-0.537 0.276-1.036 0.194-2.11-0.226-3.079l11.319-6.555c0.878 1.235 2.316 1.986 3.848 1.986 0.825 0 1.641-0.22 2.359-0.636 1.090-0.631 1.869-1.649 2.194-2.866s0.155-2.488-0.476-3.578c-0.841-1.452-2.406-2.353-4.085-2.353-0.826 0-1.641 0.22-2.359 0.636-2.051 1.188-2.872 3.694-2.015 5.833l-11.344 6.569c-0.884-1.176-2.285-1.888-3.776-1.888-0.825 0-1.641 0.22-2.359 0.636-2.25 1.303-3.021 4.194-1.718 6.444 0.841 1.452 2.406 2.353 4.085 2.353 0.826 0 1.641-0.22 2.359-0.636 0.595-0.345 1.097-0.805 1.483-1.35l11.319 6.554c-0.567 1.323-0.526 2.888 0.249 4.227 0.841 1.452 2.406 2.353 4.085 2.353 0.825 0 1.641-0.22 2.359-0.636 1.090-0.631 1.869-1.649 2.194-2.866s0.155-2.488-0.476-3.578c-0.841-1.452-2.406-2.353-4.085-2.353zM23.941 1.734c0.549-0.318 1.171-0.486 1.801-0.486 1.283 0 2.479 0.689 3.121 1.798 0.482 0.833 0.611 1.803 0.363 2.733s-0.843 1.707-1.675 2.189c-0.549 0.318-1.171 0.486-1.801 0.486-1.283 0-2.479-0.689-3.121-1.798-0.995-1.719-0.407-3.927 1.312-4.922zM8.056 19.117c-0.549 0.318-1.171 0.486-1.801 0.486-1.283 0-2.479-0.689-3.121-1.797-0.995-1.719-0.407-3.927 1.312-4.922 0.549-0.318 1.171-0.486 1.801-0.486 1.283 0 2.479 0.689 3.121 1.798 0.482 0.833 0.611 1.803 0.363 2.733s-0.843 1.707-1.675 2.189zM29.226 28.077c-0.248 0.93-0.843 1.707-1.675 2.189-0.549 0.318-1.171 0.486-1.801 0.486-1.283 0-2.479-0.689-3.121-1.797-0.995-1.719-0.407-3.927 1.312-4.922 0.549-0.318 1.171-0.486 1.801-0.486 1.283 0 2.479 0.689 3.121 1.798 0.482 0.832 0.611 1.803 0.363 2.733zM25.842 24.346c-0.308 0-0.557 0.249-0.557 0.557s0.249 0.557 0.557 0.557c0.495 0 1.655 0.598 1.655 1.759 0 0.308 0.249 0.557 0.557 0.557s0.557-0.249 0.557-0.557c0-1.886-1.802-2.873-2.769-2.873z" />
		</SVG>
	);
};

export const mapIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M16 27.667l7.849-7.849c0.146-0.139 0.464-0.469 0.478-0.483l0.006-0.007c1.972-2.116 3.059-4.874 3.059-7.766 0-6.282-5.11-11.392-11.392-11.392s-11.392 5.11-11.392 11.392c0 2.893 1.086 5.651 3.058 7.766l8.334 8.339zM16 1.265c5.677 0 10.297 4.619 10.297 10.297 0 2.613-0.981 5.104-2.761 7.016-0.092 0.096-0.343 0.353-0.446 0.451l-7.089 7.089-7.539-7.543c-1.779-1.911-2.758-4.401-2.758-7.012 0-5.678 4.619-10.297 10.297-10.297zM17.755 4.005c1.966 0 5.792 2.149 5.792 6.090 0 0.303 0.245 0.548 0.548 0.548s0.548-0.245 0.548-0.548c0-2.051-0.906-3.953-2.552-5.354-1.306-1.112-3.008-1.831-4.335-1.831-0.302 0-0.548 0.245-0.548 0.548s0.245 0.548 0.548 0.548zM22.875 24.197c-0.427-0.174-0.886-0.33-1.371-0.467l-0.897 0.897c2.645 0.631 4.275 1.756 4.275 2.802 0 1.564-3.648 3.306-8.882 3.306s-8.882-1.742-8.882-3.306c0-1.045 1.631-2.171 4.275-2.802l-0.897-0.897c-0.485 0.137-0.944 0.293-1.371 0.467-2.001 0.818-3.102 1.966-3.102 3.232s1.102 2.415 3.102 3.232c1.845 0.754 4.287 1.169 6.875 1.169s5.030-0.415 6.875-1.169c2.001-0.818 3.102-1.966 3.102-3.232s-1.102-2.415-3.102-3.232zM16.032 16.804c-3.043 0-5.519-2.476-5.519-5.519s2.476-5.519 5.519-5.519c3.043 0 5.519 2.476 5.519 5.519s-2.476 5.519-5.519 5.519zM16.032 6.862c-2.439 0-4.423 1.984-4.423 4.423s1.984 4.423 4.423 4.423c2.439 0 4.423-1.984 4.423-4.423s-1.984-4.423-4.423-4.423z" />
		</SVG>
	);
};

export const postsIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M4.285 5.775c0.004 0 0.009 0.001 0.013 0.001h8.279c0.307 0 0.556-0.249 0.556-0.556s-0.249-0.556-0.556-0.556h-8.279c-0.307 0-0.556 0.249-0.556 0.556 0 0.302 0.242 0.548 0.542 0.555zM3.743 8.005c0 0.307 0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556s-0.249-0.556-0.556-0.556h-13.679c-0.307 0-0.556 0.249-0.556 0.556zM17.977 10.236h-13.679c-0.145 0-0.276 0.056-0.375 0.147-0.11 0.102-0.18 0.247-0.18 0.409 0 0.307 0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556 0-0.162-0.070-0.307-0.18-0.409-0.099-0.091-0.23-0.147-0.375-0.147zM17.977 13.022h-13.679c-0.307 0-0.556 0.249-0.556 0.556s0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556s-0.249-0.556-0.556-0.556zM17.977 15.807h-13.679c-0.145 0-0.276 0.056-0.375 0.147-0.11 0.102-0.18 0.247-0.18 0.409 0 0.307 0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556 0-0.162-0.070-0.307-0.18-0.409-0.099-0.091-0.23-0.147-0.375-0.147zM17.977 18.593h-13.679c-0.307 0-0.556 0.249-0.556 0.555s0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556s-0.249-0.555-0.556-0.555zM17.977 21.379h-13.679c-0.307 0-0.556 0.249-0.556 0.556s0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556s-0.249-0.556-0.556-0.556zM17.977 24.165h-13.679c-0.145 0-0.276 0.056-0.375 0.147-0.11 0.102-0.18 0.247-0.18 0.409 0 0.307 0.249 0.556 0.556 0.556h13.679c0.307 0 0.556-0.249 0.556-0.556 0-0.162-0.070-0.307-0.18-0.409-0.099-0.091-0.23-0.147-0.375-0.147zM21.93 4.466l-4.277-3.87c-0.094-0.085-0.212-0.132-0.334-0.139h-15.831c-0.812 0-1.473 0.664-1.473 1.481v28.153c0 0.817 0.661 1.481 1.473 1.481h19.174c0.812 0 1.473-0.664 1.473-1.481v-25.222c-0.008-0.163-0.086-0.308-0.205-0.403zM17.833 2.238l2.331 2.109h-2.331v-2.109zM21.043 30.091c0 0.215-0.171 0.39-0.381 0.39h-19.174c-0.21 0-0.382-0.175-0.382-0.39v-28.153c0-0.215 0.171-0.39 0.382-0.39h15.251v3.348c0 0.303 0.245 0.549 0.547 0.549h3.758v24.647zM31.975 3.213c-0.125-1.57-1.442-2.809-3.044-2.809-0 0-0 0-0 0-0.816 0-1.583 0.318-2.16 0.895-0.519 0.519-0.827 1.191-0.884 1.915h-0.010v0.242c0 0.001-0 0.002-0 0.003s0 0.001 0 0.001l-0 24.342h0.003c0.010 0.096 0.045 0.191 0.108 0.273l2.509 3.305c0.103 0.136 0.264 0.216 0.435 0.216s0.331-0.080 0.435-0.216l2.508-3.305c0.063-0.083 0.098-0.177 0.108-0.274h0.003v-24.589h-0.011zM27.543 2.070c0.371-0.371 0.864-0.575 1.388-0.575h0c0.893 0 1.649 0.6 1.886 1.417h-3.772c0.091-0.315 0.26-0.604 0.498-0.842zM28.362 26.711l-1.394 0 0-22.406h3.926v22.406h-1.442l0-18.071-1.090 0 0 18.071zM28.931 30.148l-1.781-2.346 3.562-0-1.781 2.346z" />
		</SVG>
	);
};

export const pluginsIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M31.908 1.543c0-0.815-0.677-1.478-1.51-1.478h-28.731c-0.815 0-1.478 0.677-1.478 1.51v14.441c0 0.022 0.002 0.044 0.004 0.065-0.003 0.021-0.004 0.043-0.004 0.065v14.357c0 0.815 0.677 1.478 1.51 1.478h28.731c0.815 0 1.478-0.677 1.478-1.51v-14.441c0-0.022-0.002-0.044-0.004-0.065 0.003-0.021 0.004-0.043 0.004-0.065v-14.357zM30.792 1.543v13.799h-4.324c0.587-0.66 0.932-1.525 0.932-2.453 0-0.737-0.218-1.423-0.592-2-0.648-1.066-1.82-1.78-3.156-1.78-2.034 0-3.689 1.655-3.689 3.689 0 0.745 0.223 1.449 0.615 2.039 0.111 0.178 0.236 0.347 0.376 0.504h-4.372v-6.025c0-0.184-0.090-0.347-0.228-0.449-0.101-0.103-0.242-0.167-0.398-0.167h-0.173c-0.24 0-0.453 0.153-0.529 0.38-0.352 1.049-1.332 1.754-2.439 1.754-0.419 0-0.815-0.101-1.166-0.28-0.776-0.444-1.301-1.279-1.301-2.235 0-1.419 1.154-2.574 2.574-2.574 0.408 0 0.799 0.096 1.147 0.27 0.546 0.305 0.976 0.804 1.185 1.426 0.052 0.155 0.169 0.275 0.314 0.335 0.092 0.065 0.204 0.103 0.322 0.103h0.133c0.308 0 0.558-0.25 0.558-0.558v-6.142h13.816c0.217 0 0.394 0.162 0.394 0.362zM1.305 1.575c0-0.217 0.162-0.394 0.362-0.394h13.732v4.404c-0.239-0.216-0.505-0.401-0.793-0.549-0.536-0.297-1.148-0.464-1.791-0.464-2.034 0-3.689 1.655-3.689 3.689 0 1.423 0.81 2.659 1.992 3.274 0.534 0.301 1.149 0.473 1.804 0.473 0.939 0 1.813-0.354 2.476-0.955v4.404h-6.016c-0.308 0-0.558 0.25-0.558 0.558v0.173c0 0.127 0.043 0.245 0.117 0.34 0.065 0.129 0.178 0.231 0.321 0.279 0.562 0.189 1.023 0.558 1.332 1.030 0.232 0.39 0.364 0.842 0.364 1.318 0 1.419-1.154 2.574-2.574 2.574-0.894 0-1.682-0.458-2.144-1.151-0.236-0.389-0.372-0.844-0.372-1.331-0-1.107 0.705-2.087 1.754-2.44 0.227-0.076 0.38-0.289 0.38-0.529v-0.133c0-0.106-0.030-0.204-0.081-0.288-0.068-0.231-0.282-0.4-0.535-0.4h-6.084v-13.883zM1.305 30.505v-13.799h4.324c-0.587 0.66-0.932 1.525-0.932 2.453 0 0.737 0.218 1.424 0.592 2 0.647 1.066 1.82 1.78 3.156 1.78 2.034 0 3.689-1.655 3.689-3.689-0-0.745-0.223-1.449-0.615-2.040-0.111-0.178-0.236-0.347-0.376-0.504h4.372v6.025c0 0.184 0.090 0.347 0.228 0.449 0.101 0.103 0.242 0.167 0.398 0.167h0.173c0.24 0 0.453-0.153 0.529-0.38 0.352-1.049 1.332-1.754 2.439-1.754 0.419 0 0.815 0.101 1.165 0.28 0.776 0.444 1.301 1.279 1.301 2.236 0 1.419-1.154 2.574-2.574 2.574-0.408 0-0.799-0.096-1.147-0.27-0.546-0.305-0.976-0.804-1.185-1.426-0.052-0.155-0.169-0.275-0.314-0.336-0.092-0.065-0.204-0.103-0.322-0.103h-0.133c-0.308 0-0.558 0.25-0.558 0.558v6.142h-13.816c-0.217-0-0.394-0.163-0.394-0.362zM30.792 30.472c0 0.217-0.162 0.394-0.362 0.394h-13.732v-4.404c0.239 0.216 0.505 0.401 0.792 0.548 0.536 0.297 1.148 0.464 1.791 0.464 2.034 0 3.689-1.655 3.689-3.689 0-1.423-0.81-2.659-1.993-3.274-0.534-0.301-1.149-0.473-1.804-0.473-0.939 0-1.813 0.354-2.476 0.955v-4.404h6.016c0.308 0 0.558-0.25 0.558-0.558v-0.173c0-0.126-0.044-0.245-0.117-0.34-0.064-0.129-0.178-0.231-0.321-0.279-0.562-0.189-1.023-0.558-1.332-1.030-0.232-0.389-0.363-0.842-0.363-1.318 0-1.419 1.154-2.574 2.574-2.574 0.894 0 1.682 0.458 2.144 1.151 0.236 0.389 0.372 0.844 0.372 1.331 0 1.107-0.705 2.087-1.754 2.439-0.227 0.076-0.38 0.289-0.38 0.529v0.133c0 0.106 0.030 0.204 0.081 0.289 0.068 0.231 0.282 0.4 0.535 0.4h6.084v13.883z" />
		</SVG>
	);
};

export const servicesIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M15.517 23.581c-0.036 0.002-0.069-0.003-0.102-0.009-0.108-0.019-0.211-0.070-0.294-0.153l-9.153-9.153c-0.104-0.104-0.162-0.245-0.162-0.392s0.058-0.288 0.163-0.392l2.13-2.129c0.217-0.217 0.568-0.217 0.784 0l6.633 6.633 12.94-12.94c0.217-0.217 0.568-0.217 0.785 0l2.13 2.13c0.104 0.104 0.163 0.245 0.163 0.392s-0.058 0.288-0.162 0.392l-15.46 15.46c-0.104 0.104-0.245 0.163-0.392 0.163zM7.145 13.873l8.37 8.37 14.678-14.678-1.345-1.345-12.94 12.94c-0.217 0.217-0.568 0.217-0.785 0l-6.633-6.633-1.345 1.345zM30.087 11.781c0.401 1.337 0.618 2.753 0.618 4.219 0 8.108-6.596 14.704-14.705 14.704s-14.704-6.596-14.704-14.704c0-8.108 6.596-14.705 14.704-14.705 3.79 0 7.25 1.442 9.86 3.805l0.785-0.785c-2.812-2.564-6.549-4.129-10.645-4.129-8.72 0-15.814 7.094-15.814 15.814s7.094 15.814 15.814 15.814c8.72 0 15.814-7.094 15.814-15.814 0-1.784-0.297-3.501-0.845-5.102l-0.883 0.883z" />
		</SVG>
	);
};

export const pricingIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M17.425 25.368h-3.22v-2.107c-1.234-0.109-2.518-0.463-3.389-0.944l-0.373-0.206 0.93-3.628 0.622 0.341c0.602 0.33 1.835 0.883 3.323 0.883 0.769 0 1.545-0.244 1.545-0.789 0-0.365-0.235-0.783-1.938-1.358-1.985-0.668-4.264-1.78-4.264-4.477 0-2.098 1.387-3.709 3.652-4.289v-2.162h3.22v1.931c1.366 0.11 2.263 0.465 2.838 0.736l0.416 0.196-0.937 3.53-0.621-0.298c-0.539-0.259-1.442-0.692-2.853-0.692-0.488 0-1.307 0.088-1.307 0.681 0 0.448 1.192 0.94 2.231 1.319 2.781 0.973 3.971 2.344 3.971 4.58 0 1.114-0.391 2.124-1.13 2.922-0.668 0.721-1.601 1.236-2.716 1.503v2.328zM15.307 24.266h1.016v-2.139l0.457-0.079c2.090-0.36 3.389-1.676 3.389-3.433 0-1.446-0.551-2.601-3.24-3.542-1.624-0.592-2.962-1.176-2.962-2.357 0-0.862 0.633-1.783 2.409-1.783 1.213 0 2.119 0.278 2.746 0.536l0.36-1.354c-0.565-0.222-1.372-0.445-2.517-0.479l-0.535-0.016v-1.886h-1.016v1.959l-0.45 0.084c-2.005 0.375-3.202 1.61-3.202 3.305 0 1.577 1.051 2.604 3.514 3.432 1.396 0.472 2.688 1.089 2.688 2.402 0 1.149-1.039 1.891-2.647 1.891-1.312 0-2.447-0.366-3.222-0.708l-0.369 1.437c0.709 0.309 1.808 0.617 3.045 0.654l0.535 0.016v2.058zM15.901 30.607c-8.054 0-14.607-6.552-14.607-14.606s6.552-14.607 14.607-14.607c8.054 0 14.607 6.552 14.607 14.607 0 2.567-0.667 4.981-1.834 7.079l1.095 0.293c1.174-2.2 1.841-4.71 1.841-7.373 0-8.662-7.047-15.709-15.709-15.709s-15.709 7.047-15.709 15.709 7.047 15.709 15.709 15.709c2.752 0 5.34-0.712 7.592-1.96l-0.294-1.099c-2.148 1.244-4.641 1.957-7.297 1.957zM29.539 31.709c-0.141 0-0.282-0.054-0.39-0.161l-2.673-2.673-0.86 1.786c-0.1 0.208-0.32 0.331-0.548 0.31s-0.421-0.184-0.481-0.406l-1.977-7.377c-0.051-0.19 0.004-0.393 0.143-0.532s0.342-0.194 0.532-0.143l7.377 1.977c0.222 0.060 0.385 0.252 0.406 0.481s-0.102 0.448-0.31 0.548l-1.787 0.86 2.673 2.672c0.103 0.103 0.161 0.244 0.161 0.39s-0.058 0.286-0.161 0.39l-1.717 1.717c-0.108 0.107-0.249 0.161-0.39 0.161zM26.318 27.385c0.145 0 0.285 0.057 0.39 0.161l2.832 2.832 0.938-0.938-2.832-2.832c-0.126-0.126-0.184-0.306-0.154-0.482s0.143-0.327 0.304-0.404l1.148-0.552-5.020-1.345 1.345 5.020 0.552-1.148c0.077-0.161 0.228-0.274 0.404-0.304 0.031-0.005 0.062-0.008 0.092-0.008zM20.272 5.201c1.977 0 5.826 2.162 5.826 6.126 0 0.304 0.247 0.551 0.551 0.551s0.551-0.247 0.551-0.551c0-2.063-0.912-3.976-2.568-5.387-1.314-1.119-3.025-1.842-4.361-1.842-0.304 0-0.551 0.247-0.551 0.551s0.247 0.551 0.551 0.551z" />
		</SVG>
	);
};

export const testimonialsIcon = () => {
	return (
		<SVG viewBox="0 0 32 32" style={ { padding: '1px', fill: '#000000' } } xmlns="http://www.w3.org/2000/svg">
			<Path d="M31.438 1.423h-30.877c-0.31 0-0.562 0.251-0.562 0.562v22.175c0 0.31 0.251 0.562 0.562 0.562h3.103v5.294c0 0.201 0.107 0.386 0.281 0.486 0.087 0.050 0.184 0.075 0.281 0.075s0.194-0.025 0.281-0.075l10.012-5.78h16.919c0.31 0 0.562-0.251 0.562-0.562v-22.175c0-0.31-0.251-0.562-0.562-0.562zM30.877 23.598h-16.508c-0.099 0-0.195 0.026-0.281 0.075l-9.3 5.369v-4.883c0-0.31-0.251-0.562-0.562-0.562h-3.103v-21.052h29.753v21.052zM4.386 7.532h22.894c0.31 0 0.562-0.251 0.562-0.562s-0.251-0.562-0.562-0.562h-22.894c-0.31 0-0.562 0.251-0.562 0.562s0.251 0.562 0.562 0.562zM4.386 11.865h22.894c0.31 0 0.562-0.251 0.562-0.562s-0.251-0.562-0.562-0.562h-22.894c-0.31 0-0.562 0.251-0.562 0.562s0.251 0.562 0.562 0.562zM4.386 16.198h22.894c0.31 0 0.562-0.251 0.562-0.562s-0.251-0.562-0.562-0.562h-22.894c-0.31 0-0.562 0.251-0.562 0.562s0.251 0.562 0.562 0.562zM4.386 20.53h22.894c0.31 0 0.562-0.251 0.562-0.562s-0.251-0.562-0.562-0.562h-22.894c-0.31 0-0.562 0.252-0.562 0.562s0.251 0.562 0.562 0.562z" />
		</SVG>
	);
};

export const barcodeIcon = () => {
	return (
		<SVG viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
			<Path d="M0 448V64h18v384H0zm26.857-.273V64H36v383.727h-9.143zm27.143 0V64h8.857v383.727H54zm44.857 0V64h8.857v383.727h-8.857zm36 0V64h17.714v383.727h-17.714zm44.857 0V64h8.857v383.727h-8.857zm18 0V64h8.857v383.727h-8.857zm18 0V64h8.857v383.727h-8.857zm35.715 0V64h18v383.727h-18zm44.857 0V64h18v383.727h-18zm35.999 0V64h18.001v383.727h-18.001zm36.001 0V64h18.001v383.727h-18.001zm26.857 0V64h18v383.727h-18zm45.143 0V64h26.857v383.727h-26.857zm35.714 0V64h9.143v383.727H476zm18 .273V64h18v384h-18z" />
		</SVG>
	);
};

export const topIcon = () => {
	return (
		<SVG className="custom-icon" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
			<Path d="M17.294,17.287l-14.588,0l0,-14.574l14.588,0c0,4.858 0,9.716 0,14.574Zm-13.738,-0.85l12.888,0l0,-12.874l-12.888,0c0,4.291 0,8.583 0,12.874Z" />
			<rect x="4.489" y="4.744" width="11.022" height="2.512"></rect>
		</SVG>
	);
};

export const middleIcon = () => {
	return (
		<SVG className="custom-icon" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
			<Path d="M17.294,17.287l-14.588,0l0,-14.574l14.588,0c0,4.858 0,9.716 0,14.574Zm-13.738,-0.85l12.888,0l0,-12.874l-12.888,0c0,4.291 0,8.583 0,12.874Z" />
			<rect y="8.744" width="11.022" x="4.489" height="2.512"></rect>
		</SVG>
	);
};

export const bottomIcon = () => {
	return (
		<SVG className="custom-icon" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
			<Path d="M17.294,17.287l-14.588,0l0,-14.574l14.588,0c0,4.858 0,9.716 0,14.574Zm-13.738,-0.85l12.888,0l0,-12.874l-12.888,0c0,4.291 0,8.583 0,12.874Z" />
			<rect x="4.489" y="12.802" width="11.022" height="2.512"></rect>
		</SVG>
	);
};

export const navigatorIcon = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20" height="20">
		<Path d="M5 5H3v2h2V5zm3 8h11v-2H8v2zm9-8H6v2h11V5zM7 11H5v2h2v-2zm0 8h2v-2H7v2zm3-2v2h11v-2H10z" />
	</SVG>
);
