# Hestia Pro #
**Contributors:** [themeisle](https://profiles.wordpress.org/themeisle)  
**Tags:** blog, custom-logo, portfolio, e-commerce, rtl-language-support, post-formats, grid-layout, one-column, two-columns, custom-background, custom-colors, custom-header, custom-menu, featured-image-header, featured-images, flexible-header, full-width-template, sticky-post, theme-options, threaded-comments, translation-ready, editor-style, footer-widgets, left-sidebar, right-sidebar, wide-blocks  
**Requires at least:** 4.0  
**Tested up to:** 5.0  
**Stable tag:** 2.0.7  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html  

Hestia Pro fits all business, startups, corporate businesses, online companies, portfolios, e-commerce (WooCommerce), and freelancers.

## Description ##
Hestia is a modern WordPress theme for professionals. It fits creative business, small businesses (restaurants, wedding planners, sport/medical shops), startups, corporate businesses, online agencies and firms, portfolios, ecommerce (WooCommerce), and freelancers. It has a multipurpose one-page design, widgetized footer, blog/news page and a clean look, is compatible with: Flat Parallax Slider, Photo Gallery, Travel Map and Elementor Page Builder . The theme is responsive, WPML, Retina ready, SEO friendly, and uses Material Kit for design.

## Copyright ##
Hestia WordPress theme, Copyright 2018 Themeisle
Hestia is distributed under the terms of the GNU GPLv2 or later

## Changelog ##
### 2.5.6 - 2019-12-17  ###

* [Fix] Logo positioning for the third navigation layout option and no widgets
* [Fix] Sync between the image set as the featured image for the Frontpage and the image from the About section
* [Fix] Customizer icons missing when Font Awesome was not loaded
* [Fix] Compatibility with the Menu Icons plugin while the transparent menu is on


### 2.5.5 - 2019-11-14  ###

* [Feat] Dedicated logo option for the transparent header
* [Fix] Subscribe form on the blog page
* [Fix] Line separator compatibility with WP 5.3


### 2.5.4 - 2019-10-21  ###

* [Fix] Blog page Infinite Scroll compatibility with the Alternative layout
* [Fix] Cover block text color not updating
* [Fix][Hestia Pro] Shop page Infinite Scroll compatibility with widgets filtering
* [Fix][Hestia Pro] Header layout selection for the Shop page
* [Fix][Hestia Pro] Slider arrows position on RTL


### 2.5.3 - 2019-09-13  ###

* [Fix] Improved About page layout
* [Fix] License validation mechanism for Starter Sites


### 2.5.2 - 2019-09-12  ###

* [Fix] Compatibility with Elementor Pro Menu Cart widget
* [Fix] Mail and phone icons compatibility with FA5
* [Fix] Primary menu icons spacing and alignment
* [Fix] Uppercase submenu items back to Sentence case
* [Fix] WooCommerce product gallery images not clickable on mobile
* [Perf] Small performance fixes


### 2.5.1 - 2019-08-13  ###

* [Fix] - Header layout on the front page
* [Fix] - Removed Hestia's custom integration with Gutenberg
* [Fix] - Social menu icons compatibility with FA5


### 2.5.0 - 2019-08-08  ###

* Migrated to Font Awesome 5
* Updated the Starter Sites library


### 2.4.9 - 2019-08-01  ###

* Allow copyright text to be changed in both Hestia and Hestia PRO
* Allow HTML tags in the title and subtitle fields of the Portfolio section
* Create a WPForms form as a default value for the Contact section
* Updated the Google Fonts Library
* Fixed header layout on the tags archive page
* Fixed issue with accent color not affecting links in the front-end
* Made sure the header image is translatable with WPML
* Fixed sidebar layout metabox not appearing when WooCommerce was not installed


### 2.4.8 - 2019-07-23  ###

* Speed improvement update for the Hestia Default Demo
* [Hestia PRO] Fixed licensing issue in the onboarding mechanism


### 2.4.7 - 2019-07-22  ###

* Fixed issue with Starter Sites not available in the pro packages


### 2.4.6 - 2019-07-18  ###

* New Customizer option to control the header area on single product pages
* [Hestia PRO] New meta option to control the header area on individual single product pages
* Fixed alignment issue between the author title and the author image on mobile devices
* Fixed header layout issue on the category page being affected by the first article layout
* Move two items per line instead of one in the Our Team section for a better spacing
* Lower header area and font sizes on mobile for better usage of the space
* Darken color for the labels on the Checkout page


### 2.4.5 - 2019-05-27  ###

* Fixed editor visual integration with the latest update of WordPress
* Fixed duplicated comments area when using Elementor Pro templates


### 2.4.4 - 2019-04-22  ###

* Removed weird scroll on the blog page


### 2.4.3 - 2019-04-22  ###

* New logging mechanism to the onboarding module
* Improved the whole routine for the content import in the onboarding module
* Added new wp_body_open() function for WP 5.2
* Fixed logo disappearing on scroll on the distraction-free checkout mode
* Made blog text color darker when using the full content articles option
* Fixed portfolio featured image not visible in Firefox in the lightbox
* Fixed overlapping content on the blog page
* Fixed incorrect title attribute for the primary menu
* Fixed Shop page layout on the third header layout
* Remove title appearing in the navigation cart in the latest update of WooCommerce


### 2.4.2 - 2019-04-02  ###

* Updated the Starter Sites library


### 2.4.1 - 2019-03-29  ###

* Compatibility with the Header, Footer & Blocks for Elementor plugin
* New Agency Travel Demo Starter Site
* Fixed issue with the color picker needing two clicks
* Updated the Contact and Facebook community links
* Updated tags list with the new tags
* Fixed importing issues with the Starter Sites
* Fixed White Label error appearing lower PHP versions
* Fixed issue with contact form shortcode not being translation ready
* Updated Starter Sites library images


### 2.4.0 - 2019-03-21  ###

* [Hestia Pro] New White Label module
* Fixed issue with Big Title buttons shadow color
* Fixed issue with Portfolio pop-up not opening in Microsoft Edge
* Fixed issue with Blog options taking control over the custom post types archives pages
* Fixed issue with invalid CSS inline style


### 2.3.0 - 2019-03-01  ###

* Fixed products categories layout on the Shop pane and Homepage
* Fixed issue with the title attribute not escaping HTML tags in the primary menu
* New Hestia Original starter site


### 2.2.1 - 2019-02-12  ###

* [Hestia PRO] Fixed issue with the [hestia_slider] shortcode not working
* Fixed search results page layout when using the second header option
* Replaced Google+ sharing option with an Email option
* Fixed link for sharing on Twitter option
* Fixed issue with color control updating only after two clicks


### 2.2.0 - 2019-02-06  ###

* NEW Hestia Specific Gutenberg blocks for Otter Blocks
* Improved the onboarding process
* New filter for compatibility with the Central Color Palette plugin
* Fixed default font weight for headings
* Fixed issue with default small font size for lists
* Allow HTML tags in the single product page title
* Fixed problem with the footer not sticking to the bottom of the blog page
* Fixed warning with the Connections plugin


### 2.1.1 - 2019-01-17  ###

* Changed the boxed layout for the third header layout
* Improved layout of the onboarding notice and page
* Small layout fixes for the Orfeo child theme
* Fixed the upgrade link


### 2.1.0 - 2019-01-09  ###

* NEW Custom integration with Gutenberg
* NEW Options to differentially enable/disable navigation and footer areas on posts/pages
* Fixed compatibility with Everest Forms plugin
* Fixed compatibility with Quiz Cat plugin
* Fixed problem with the About Section background image remaining fixed in Firefox
* Removed the Featured tag for the sticky posts


### 2.0.19 - 2018-12-18  ###

* Fixed WooCommerce related product layout in Fagri
* Fixed issue with the Very Top Bar not visible on Elementor Full Width page templates
* Fixed issue with the Contact section content area that did not opened with Gutenberg


### 2.0.18 - 2018-12-12  ###

* Revert Font Awesome 5


### 2.0.17 - 2018-12-11  ###

* Update to Font Awesome 5


### 2.0.16 - 2018-12-10  ###

* Updated Tested up to version to 5.0
* Removed unused notice


### 2.0.15 - 2018-12-05  ###

* Fixed problem with Very Top Bar not visible on mobile on the single product page
* Recommend Otter Blocks plugin


### 2.0.14 - 2018-11-30  ###

* Fixed issues with the Hestia Woocommerce Demo
* Updated theme license
* Added back filter to allow you to display the product image in the header of the single product page


### 2.0.13 - 2018-11-28  ###

* Fixed issues with retina images on the shop page
* Fixed import from Zelle
* Updated the Hestia WooCommerce demo
* Recommend Neve


### 2.0.12 - 2018-11-16  ###

* Update readme file
* Fixed warnings on the typography file
* [Fagri child theme] fix padding issue on the Pirate Forms form


### 2.0.11 - 2018-11-09  ###

* Fixed fatal error happening in a few cases


### 2.0.10 - 2018-11-06  ###

* Fixed compatibility with the latest release of WooCommerce
* Fixed compatibility with Google Console
* Added config file for Toolset plugin
* New filters used for child themes


### 2.0.9 - 2018-11-05  ###

* Fixed Google Console issues
* Small tweaks for the Sites Library Demos


### 2.0.8 - 2018-11-02  ###

* Gutenberg support
* Fixed import for Zelle ( Zerif ) to Elementor
* Improved title responsive font size for the 2nd and 3rd header layouts
* Refactored the About Hestia page
* Updated the readme file with correct license and used resources
* Fixed some escaping issues
* Fixed compatibility issues with the child themes
* Updated the screenshot
* Fixed error causing customizer not to load after a demo templated was imported



### v2.0.4 ###
*Release Date - 2018-09-11*

* Fixed issue with the dropdown menu active items
 
### v2.0.3 ###
*Release Date - 2018-09-11*

* Fixed issues with the header layout option
* [Hestia PRO] Fixed problem with embeds not working in the Portfolio lightboxes
* Fixed issue with the category description not visible on the category archive page
* [Hestia PRO] Fixed compatibility issues with Elementor Pro
* New filter for the Related Posts title that can be changed using this doc https://docs.themeisle.com/article/937-change-related-post-title-on-post-page-in-hestia-theme
 
### v2.0.2 ###
*Release Date - 2018-08-29*

* Fix issue with Import Zerif to Elementor notice
* Fix issue with the navigation menu on the tablet
 
### v2.0.1 ###
*Release Date - 2018-08-24*

* Fixed issue with woocommerce buttons
* Fixed issue on third layout on blog
* Make elementor import notice dismissible
 
 = v2.0.0 =
 *Release Date - 2018-08-24*

* NEW options for styling the buttons padding and border radius
* [Hestia PRO] NEW option for styling the buttons hover effect ( color or shadow )
* NEW options for the Blog page ( choose content or excerpt, type of pagination and hide the categories )
* [Hestia PRO] NEW layout for the Blog page with a customizable number of columns and masonry option
* New option to allow the Big Title section to be disabled
* New option to disable the custom Frontpage sections
* Fixed title problem on the archive pages for Chinese locals
* Optimized and minified the CSS and JS files
* Fixed issue with white bar appearing on mobile devices on the single product page
* Refactored the code for the primary menu
* Fixed issues with Elementor blocks extending outside the content of the page
* Fixed issues with TinyMCE
* Improved compatibility with the WPForms Lite plugin
* Fixed issue on shop with older browsers
 
 = v1.1.86 =
*Release Date - 2018-08-13*

* Updated screenshot
 
 = v1.1.85 =
*Release Date - 2018-07-26*

* Improved UX for the Subscribe section in Customizer
* Improved compatibility with the WooCommerce Compare List plugin
* Improved compatibility with the Max Mega Menu plugin
* Fixed title problem on the archive pages for locals different than English
* Fixed small layout compatibility problem with Elementor
 
### v1.1.84 ###
*Release Date - 2018-07-19*

* Fixed compatibility issues with Thrive Architect plugin
* Fixed layout issues for WooCommerce products and categories cards
* Fixed layout issues for the Shop page on Internet Explorer 11
* Redone the way sections can be overridden in child themes using this documentation:
* https://docs.themeisle.com/article/918-how-to-override-sections-in-hestia-pro
 
### v1.1.83 ###
*Release Date - 2018-07-06*

* Fixed js console errors
* Fixed mobile issue with the fallback image for the video header

### v1.1.82 ###
*Release Date - 2018-07-05*

* [Hestia PRO] Fixed problem with Big Title video size on larger devices
* [Hestia PRO] Fixed problem with the number of widget areas option in the Footer
* Made transition to a default theme, when a PHP version lower than 5.3.29 is used
* Fixed problem with the duplicated description on the products categories page
* Fixed problem with the missing cookie field in the comments form
* Fixed layout problem for categories on the Shop page
* Fixed compatibility with Orfeo child theme
* Improved Clients Bar section layout
* Small code improvements
 
### v1.1.81 ###
*Release Date - 2018-06-26*

* Fixed products alignment issue on the shop page when a left sidebar is used
* Fixed problem with the Big Title alignment option callback function
 
### v1.1.80 ###
*Release Date - 2018-06-25*

* Fixed issue with style enqueued for the About page
 
### v1.1.79 ###
*Release Date - 2018-06-25*

* Improved compatibility with WooCommerce Product Catalog options
* Fixed responsive alignment issues in the Big Title section
* Fixed issue with product/articles categories colors
* Improved frontpage Products section layout
 
### v1.1.78 ###
*Release Date -  2018-06-21*

* Refactored the entire code
* Redone the Big Title section for a better UX
* Fixed Big Title buttons alignment and notice on the checkout page in the Orfeo child theme
 
### v1.1.77 ###
*Release Date - 2018-05-24*

* Fixed compatibility with WP GDPR Compliance plugin
* Fixed problem with the Big Title Background not being able to be removed
* Fixed problem with default content added in the Very Top Bar section
 
### v1.1.76 ###
*Release Date - 2018-05-18*

* Fixed problem with some redundant strings in the lite version
 
### v1.1.75 ###
*Release Date - 2018-05-18*

* NEW Feature to allow a widget area in the Big Title/Slider section
* [Hestia PRO] Fixed alignment for the Authors Section on the Blog page
* Fix fatal error on lower PHP versions
 
 = v1.1.74 =
 *Release Date - 2018-05-10*

* [Hestia PRO] New Icon picker option in the Pricing section
* Fixed problem with title meta in the Archive page header when the language is different than English
* Fixed problem with duplicated titles when using the second header layout option
* Fixed problem with the Big Title Second Button control not working in the Orfeo child theme
* Fixed some layout issues with the WooCommerce filtering widgets in the Footer area
 
### v1.1.73 ###
*Release Date - 2018-04-24*

* Improved Cart page layout on mobile
* Fixed problem with the About and Contact sections editor not saving the input
* Fixed problem with footer section on internal pages in IE11
* Removed meta on the Archive pages - Doc to add them back https://docs.themeisle.com/article/793-how-to-add-back-category-tag-author-in-the-archive-title-in-hestia
 
### v1.1.72 ###
*Release Date - 2018-04-17*

* Compatibility with Elementor Pro 2.0 theme location API header and footer
* NEW extra options for the Big title/Slider area - Parallax effect 
* UX Customize layout improvements
* Fixed layout compatibility issues with the sidebar on bbpress and BuddyPress pages
* Fixed layout of the Search products widget
* Allow a shortcode for the Contact section
* Improved compatibility with Pirate Forms Extended plugin
* Fixed issue with sidebar position when the option for logged in users to be able to post comments is enabled
* Fixed problem with footer sticking to the bottom of the page when to little content
* Made reCaptcha button smaller on mobile devices to better accommodate the layout
 
### v1.1.71 ###
*Release Date - 2018-03-14*

* Fixed problem with the preview images not showing anymore on the blog page
* Fixed problem with the parallax effect on inner pages
 
### v1.1.70 ###
*Release Date - 2018-03-08*

* Fixed alignment issues with the Featured posts area
 
### v1.1.69 ###
*Release Date - 2018-03-08*

* Fixed alignment issue in the featured posts area
 
### v1.1.68 ###
*Release Date - 2018-03-07*

* Fixed compatibility issues with WooCommerce 3.3 thumbnail cropping options
 
### v1.1.67 ###
*Release Date - 2018-03-06*

* NEW Featured posts area section on the blog
* Fixed compatibility issues with WooCommerce 3.3 thumbnail cropping options
* Fixed compatibility issues with WeGlot plugin language switcher
* Fixed problems with synchronization between the About section and the front page
* Fixed compatibility with the Invisible reCaptcha plugin
* [Hestia PRO] Removed constricted video dimensions
* Made Social Sharing strings translatable
* Fixed fatal error with PHP 5.2
* Fixed issue with random images appearing on the blog page in child themes
 
### v1.1.66 ###
*Release Date - 2018-02-19*

* Fixed responsive alignment on the shop page
 
### v1.1.65 ###
*Release Date - 2018-02-16*

* Fixed compatibility issues with Pirate Forms on mobile
* Fixed warning appearing in the Blog section
* [Hestia PRO] Fixed empty cart layout in navigation area
* Fixed issues with the Header layout control
 
### v1.1.63 ###
*Release Date - 2018-02-14*

* [Hestia PRO] Option to open portfolios in a lightbox
* [Hestia PRO] Added animations for frontpage sections
* [Hestia PRO] Fixed compatibility issues for the navigation cart with variable products
* [Hestia PRO] Improved navigation cart layout on mobile devices
* [Hestia PRO] Allowed some formatting tags in the Slider section buttons
* New option for choosing the Header area layout
* [Hestia PRO] Two new layouts for the Header area
* Small fixes for WooCommerce widgets and product layouts
* Made entire team member boxes clickable
* Fixed problem with third level menu items getting hidden when parent menu item had description
* Fixed alignment problem on IE11 for megamenu
* Fixed problem with dropdown menu items on Firefox
* Added styling for more widgets in the Subscribe section
* Removed characters limitation for WooCommerce product's titles
 
### v1.1.62
*Release Date - 2018-01-31*

* Improved compatibility with WooCommerce 3.3
* Fixed problem with container width control not working properly
* Added missing about-contact.png image
* Fixed warning: Implode function invalid arguments passed
 ###
### v1.1.61 ###
*Release Date - 2018-01-30*

* Fixed problem with dismissable notification
 
### v1.1.60 ###
*Release Date - 2018-01-29*

* [Hestia PRO] New option to disable the transparent state of the navigation bar
* [Hestia PRO] New option for changing the color in the hover state of the navigation bar items
* [Hestia PRO] New Category select option for the Blog frontpage section
* [Hestia PRO] Fix video header overflowing body
* New Font size controls for Frontpage sections
* Improved migration function from the old font size controls
* Added hooks for the Clients Bar and Ribbon sections
* Fixed problems with navigation color options for drop-down menus
* Basic enhancements to the editor area
* Small layout fixes for WooCommerce pages
* Fixed synchronization function for the About frontpage section image and content
* Optimize theme for a smaller size archive
* Improved compatibility with Pirate Forms plugin
* Made footer stick to the bottom of the pages no matter the content size
* Customizer selective refresh UX changes
* Added a filter to allow using the product featured image as header image on product pages using this document http://docs.themeisle.com/article/814-how-to-display-the-product-image-in-the-header-of-the-single-product-page-in-hestia
* Fixed problem with Yoast SEO meta title showing on the Blog page
* Fixed front page sections problem with alt tags for attached images
* New hook added to allow a title and subtitle in the Clients Bar section using this doc http://docs.themeisle.com/article/816-how-to-add-a-title-and-a-subtitle-in-the-clients-bar-section-in-hestia
* Fixed mobile issue with the logo on iOS devices
* Other small code improvements
 
### v1.1.59 ###
*Release Date - 2018-01-11*

* NEW option to enable the main Header Image on all posts and pages, instead of the featured images
* NEW option for selecting posts and pages individual layouts
* Fixed problem with font sizes for paragraphs and headings not changing in Elementor
* [Hestia PRO] Fixed compatibility issue with Elementor and the Full-screen menu Customize option
* Improved font size migration function to better match the initial values
* Replaced the featured image in the header with the category image for Single Product Pages
* Added missing alt tag to the logo element
* Improved selective refresh for all Customize options
* [Hestia PRO] Improved the Blog Layout and Footer Layout controls
* Fixed issue with About section background causing slow scrolling on iOS devices
* Limit the number of categories, title and description's words for each WooCommerce Product box for a better layout across the site, using filters that can be further used in child themes
* Two new filters to allow users changing the post meta data on single post pages and on the blog using this documentation http://docs.themeisle.com/article/807-how-to-change-post-meta-data-in-hestia
 
### v1.1.58 ###
*Release Date - 2017-12-29*

* Improved migration from old Font Size options to the new options
* Imported theme mods when switching from a Themeisle child theme to Hestia
 
### v1.1.57 ###
*Release Date - 2017-12-25*

* Redone Font Size options. Added controls for Posts & Pages Title, Heading and Content
* [Hestia PRO] New control for changing the Menu font size
* Improved default font sizes to better suit mobile devices
* [Hestia PRO] Added Code Editor and linting to Hestia PRO Hooks Page
* Fixed H2 tags not displaying on the Frontpage Shop Section
* Fixed conflict with Event Espresso Calendar addon
* Minified images
 
### v1.1.56 ###
*Release Date - 2017-11-28*

* Added back titles on pages when WooCoomerce is not installed
 
### v1.1.55 ###
*Release Date - 2017-11-27*

* [New Feature] Scroll to top option
* [New Feature] Search icon in the navigation menu
* Fixed issue with primary menu items not visible on iPads
* [Hestia PRO] Fixed issue with the footer widgets layout
* Fixed issue with Team member section not opening external links in a new tab
* [Hestia PRO] Fixed issue with navbar background color on mobile devices
* [Hestia PRO] Fixed issue with navigation menu ( with the Full menu option activated ) closing button color
* Improved layout for the WooCommerce Cart and Checkout pages
* Fixed alignment issues with the front page sections
 
### v1.1.54 ###
*Release Date - 2017-11-13*

* Updated resources for bundled images
* Removed duplicated featured images on single portfolio pages
* Added missing IDs for Ribbon and Clients Bar sections
* Fixed issue with hidden label for the custom color controls in customizer in WordPress 4.9
* Allow Skip logo cropping
 
### v1.1.53 ###
*Release Date - 2017-11-06*

* [Hestia PRO] NEW Video background option in the header area
* [Hestia PRO] NEW Container width option
* [Hestia PRO] New option for changing the Header Gradient color
* Fixed compatibility issues with SiteOrigin Page Builder overriding the About section
* Fixed WooCommerce layout for single product pages when no tabs were displayed
 
### v1.1.52 ###
*Release Date - 2017-10-24*

* Fixed problem with parallax effect in the Ribbon section on iOS
* New filter for the header background wrapper to be used in a child theme, to allow users to have a featured image for each category - http://docs.themeisle.com/article/706-how-to-use-categories-featured-images-as-header-image-in-hestia
* Fixed vertical alignment issue on frontpage Products section
* Fixed compatibility responsive issues with Pirate Forms
* Fixed callback function used for the custom logo
* Fixed issue with items descriptions appearing in the primary menu
* Fixed active buttons color issue in the primary menu
* Fixed small JavaScript console error in Customizer
 
### v1.1.51 ###
*Release Date - 2017-10-18*

* [Hestia PRO] New cart icon in the primary menu when WooCommerce is used
* Improved migration compatibility from Zerif to Hestia
* Improved responsive layout
* Fixed issues with blurred images in the Shop section on mobile
* Improved frontpage sections hide/show control by adding selective refresh
* Improved UX for the WYSIWYG control used in the About section
* Added a basic Mega Menu compatibility - http://docs.themeisle.com/article/704-hestia-basic-mega-menu-setup
* Integration with PayPal for WooCommerce plugin
* Integration with MailChimp for WordPress
* Fixed issues in the Primary menu with active items
* Fixed small issue with font awesome icons disappearing from the About section content
* Fixed small issue with selective refresh on Sidebar width option
* Made all functions in template-tags.php pluggable to allow better child theme usage
* Made all frontpage sections external links open in a new tab
* Added some new filters to control the number of items per row appear in the Features, Testimonials and Blog Frontpage section - http://docs.themeisle.com/article/669-how-to-add-4-feature-items-on-a-line-in-hestia
* Fixed issue in RTL mode with Sidebar layout control icons
* Fixed selective refresh for the Tagline option
 
### v1.1.50 ###
*Release Date - 2017-10-02*

* NEW improved options for frontpage sections ordering/disabling
* NEW Header Background gradient option
* NEW default template Page with Sidebar
* Improved Shop page's layout when using both categories and products
* Use the blog featured image as header image on that page
* Migration compatibility from Azera Shop to Hestia
* Migration compatibility from Parallax One to Hestia
* Migration compatibility from Llorix One Lite to Hestia
* Removes generic classes, prefixed with hestia keyword now
* Improved Customize layout with scrolling to the currently selected section
* Fixed issue with About section image taking one of the posts images when the sections are subsequent
* Fixed JS console error sometimes appearing when using cache plugins
 
### v1.1.48 ###
*Release Date - 2017-09-19*

* Fixed JS errors that were causing some Elementor pages not to load
* Reduced the number of placeholder icons in the iconpicker to fix loading issues on some hostings
* Made external links in the Clients Bar section open in a new tab
* Fixed selective refresh on frontpage sections titles
* Fixed problems with WooCommerce elements on RTL sites
* Fixed small alignment issue with the Slider buttons on responsive mode
* Fixed small visual bug on the search icon
 
### v1.1.47 ###
*Release Date - 2017-09-12*

* New Ribbon section
* New Clients Bar section
* [Hestia PRO] New WooCommerce shortcode option in the Frontpage Shop section
* [Hestia PRO] Fixed issue with Frontpage Features, Team, Testimonials, Contact sections content not translatable with Polylang
* Fixed Internet Explorer 11 issue with Big Title section button not clickable
* Fixed Big Title/Slider issue with iframes in Safari
* Reorganize Customize layout with tabs controls
* Default WooCommerce image for products with no featured image
* Made the Very Top Bar fixed at the top of the screen
* Removed unused jQuery MatchHeight script
 
### v1.1.46 ###
*Release Date - 2017-08-24*

* Fixed issue with colors options not appearing in the Features section
* Fixed issue with the About section not working
* Recommend Elementor plugin
 
### v1.1.45 ###
*Release Date - 2017-08-22*

* Fixed Frontpage sections image options not working properly since the last update
* Added page title in header for the blog page, instead of the Site tagline
 
### v1.1.44 ###
*Release Date - 2017-08-21*

* [Hestia PRO] New option to allow images instead of icons in the Features section
* New option for layout alignment in the Big title/Slider Section
* [Hestia PRO] New option for a second button in the Slider Section
* [Hestia PRO] New color options for buttons in the Slider Section
* Fixed Typography options on WooCommerce single product pages
* [Hestia PRO] New panel in admin area for Hooks control
* Fixed compatibility with Dokan Multivendor Marketplace plugin
* Fixed compatibility with Nex Forms plugin add-on
* Fixed issue with dropdown menus overflowing when large items are used in the menu
* Fixed issue with products gallery on latest WooCommerce update
* Fixed small responsive issues
* Added some more hooks for frontpage control
* Fixed vertical alignment issue with logo on mobile devices
* Fixed issue with frontpage sections not centering
* Separate and load CSS conditionally
* Small changes to Customize layout
* Changes to enqueue fonts conditionally
* Changed Font subsets control to a multiple select
* Removed Menu icon on mobile devices, when no menu is selected
 
### v1.1.43 ###
*Release Date - 2017-08-08*

* Fixed issue with colors not working in the Features section
* Fixed issue with menu opening automatically on mobile devices
* Fixed issue with footer icons color when the Alternative Footer option is selected
 
### v1.1.42 ###
*Release Date - 2017-08-04*

* Fix feature section controls.
* Fix testimonial section controls. 
* Fix JetPack compatibility issues in customizer.
* Fix subscribe section.
* Improved UX of customizer.

### 1.1.41 ###
*Release Date - 2017-07-28*

* New Top Bar section
* [Hestia PRO] Top Bar section colors and alignment options
* New Multiple Header Layouts
* [Hestia PRO] New Option for a Full width menu in header
* [Hestia PRO] New Extra Options for Shop section ( category and order filters )
* New Alternative Footer Style
* [Hestia PRO] New Option for selecting the number of Footer Widgets Columns
* Allow HTML tags in Features, Team and Testimonials sections
* Changed responsive layout of sidebar
* Fixed Google Webmaster Tools errors
* Added hooks for header, footer and frontpage sections
* Improved subtitles spacing on frontpage
* Fixed some CSS issues in the main navigation menu

### 1.1.39 ###
*Release Date - 2017-07-21*

* Fixed responsive bugs with the main navigation menu
* Fixed blurred background image bug on about section on iPhone
* Fixed typography bug with H1 headings not changing size on posts and pages
* Added support for Snapchat, Email, Tel, Deviantart and Vimeo in the footer social menu
* Open in a new tab all external links used in Big title section / Slider section
* Fixed some small layout bug on checkout page for shipping options
* Compressed image for a smaller archive
* Smaller size images for Shop and Portfolio sections

### 1.1.38 ###
*Release Date - 2017-07-14*

* New Typography options
*Style Elementor plugin's widgets
*Improved all responsive structure
*Improved compatibility with WooCommerce Germanized plugin
*Support for hiding Hestia frontpage sections in Elementor
*Improved cart and checkout layout
*Fixed issue with Polylang Language switcher HTML tags used as title attribute

### 1.1.37 ###
*Release Date - 2017-06-30*

* New option to allow multiple dropdown levels for the main navigation menu
* New editor style feature
* New Shortcodes options for each of the frontpage sections
* Compatibility with major Form plugins: Contact Form 7, WP forms, Ninja Forms, Formidable Forms, Visual Form Builder, Fast Secure Contact Form, Jetpack Contact form, MailChimp
* New options for customizing the Footer layout + Support for Socials menu in the footer area
* Redone some visual elements to better match the Material Design
* Fixed SEO issue with the meta description on the single post page
* Allow classes for i html tags in textarea inputs for the frontpage
* Added versioning for all assets used in the theme
* Fixed issue with contact form placeholder not working in Mozilla Firefox

### 1.1.33 ###
*Release Date - 2017-06-20*

* Fixed form placeholder issues on Mozilla Firefox
* Remove support for WPML on frontpage

### 1.1.32 ###
*Release Date - 2017-06-13*

* Updated some strings

### 1.1.31 ###
*Release Date - 2017-06-13*

* New option in Hestia PRO for selecting the sidebar's width
* Improved layout of cart and checkout pages for WooCommerce
* Added Install & Activate buttons for the recommended plugins
* Added selective refresh to all options for better UX
* Added started content
* Converted Contact content option from textarea to WYSIWYG
* Prefixed all generic CSS classes with hestia
* Fixed issue with inputs of type file beeing not visible in content
* Removed the sidebar on Cart and Checkout pages
* Other small CSS improvements

### 1.1.30 ###
*Release Date - 2017-06-07*

* Removed redundant trailingslashit causing warnings

### 1.1.29 ###
*Release Date - 2017-06-07*

* Redid some of the strings used in the theme
* Recommend BeaverBuilder plugin instead of SiteOrigin Panels
* Fixed menu dropdown colors
* Fixed Warning: Cannot modify header information – headers already sent

### 1.1.28 - 2017-06-07*

* Improved theme description and tags
###
### 1.1.27 ###
*Release Date - 2017-06-06*

* Development


### 1.1.25 ###
*Release Date - 2017-06-06*

* Refractor CSS code to SCSS
* New 'Page Builder Full Width' and 'Page Builder Blank' templates for page builders
* Compatibility with Elementor plugin
* Compatibility with Beaver Builder plugin
* Compatibility with Beaver Themer plugin
* New WooCommerce sidebar
* New 'Blog Sidebar Layout' option for changing the layout of the sidebar on blog pages
* New 'Page Sidebar Layout' option for changing the layout of the sidebar on normal pages
* Fixed issue with logo size on various dimensions
* Fixed issue with duplicated Added to cart button on Firefox on frontpage
* Fixed issue with primary menu active color

### 1.1.24 ###
*Release Date - 2017-05-29*

* Improved primary menu smooth scrolling option
* Improved search button layout to better match the whole design
* Improved description and tags

### 1.1.23 ###
*Release Date - 2017-05-25*

* Fixed issues with the WYSIWYG editor in customize
* Added versioning for scripts and styles to better manage caching
* Changed upsell mechanism
* Removed footer layout when no widgets are added there

### 1.1.22 ###
*Release Date - 2017-05-21*

- Added default blog post images for preview
- Changed the default accent color
- Changed default Big title/Slider image to match screenshot
- Changed header height and navbar transparency behaviour
- Update license for material kit

### 1.1.21 ###
*Release Date - 2017-05-19*

* Fixed escaping issues
* Changed defaults for some titles and subtitles
* Added selective refresh for some theme mods

### 1.1.20 ###
*Release Date - 2017-05-16*

* Fixed prefixing issues
* Added registering function for default headers
* Loading main style file through get_stylesheet_uri()
* Fixed small escaping issues

### 1.1.19 ###
*Release Date - 2017-05-11*

* Import content for users coming from Zerif
* Allow basic HTML formatting tags in repeater textarea
* Fixed issue with colors selection in child themes
* Added About Hestia page

### 1.1.17 ###
*Release Date - 2017-04-21*

* Update font-awesome library
* Allow HTML tags in the slider section and in the Big title section

### 1.1.16 ###
*Release Date - 12/04/2017-04-12*

* Replaced screenshot
* Fixed thumbnails issues with WooCommerce 3.0.0
* Fixed jquery-ui dependency causing scripts not to load

### 1.1.15 ###
*Release Date - 2017-04-06*

* Fixed grund and fatal error when woocoommerce is not installed

### 1.1.14 ###
*Release Date - 2017-04-06*

* Fixed compatibility issues with WooCommerce 3.0.0
* Fixed issues with shortcodes and scripts entered in the About section

### 1.1.13 ###
*Release Date - 2017-04-05*

* Fixed issue with shortcodes used in the About section causing Customizer to not load
* Fixed repeater using 'file_get_contents' function.

### 1.1.12 ###
*Release Date - 2017-03-31*

* Fixed compatibility issue with Elementor page builder plugin

### 1.1.11 ###
*Release Date - 2017-03-28*

* Fixed loading time issue in Mozilla Firefox
* Fixed small layout issues
* Refractor code
* Improved escaping

### 1.1.9 ###
*Release Date - 2017-03-13*

* Fixed default cases for frontpage sections controls

### 1.1.8 ###
*Release Date - 2017-03-13*

* Created Hestia Companion plugin for lite users
* Fixed pricing display issue on frontpage for WooCommerce products
* Fixed layout issues with ul and ol lists
* Added starter content for new users

### 1.1.7 ###
*Release Date - 2017-03-02*

* Fixed issue with the sidebar position when only logged in users are able to posts comments
* Fixed issue with translations in the Pricing section

### 1.1.6 ###
*Release Date - 2017-02-23*

* Solved comment form issue.

### 1.1.5 ###
*Release Date - 2017-02-09*

* Make theme compatible with WPML and Polylang
* Improved Customize upsell layout

### 1.1.4 ###
*Release Date - 2017-01-25*

* Use correct instructions for Sendinblue widget
* Changed slider speed from 400 seconds to 10 seconds
* Adjusted padding on menu items to match material kit pro

### 1.1.3 ###
*Release Date - 2017-01-16*

* Fixed issue with submit button not centering on full width pages using Pirate Forms
* Added synchronized controls in the About section to allow customization
* Fixed issue with hover color for menu items
* Changed the way style.css is enqueued for child theme compatibility

### 1.1.2 ###
*Release Date - 2016-12-14*

* Reorganize theme files
* Remove unused image
* Fixed issue with sticky post layout

### 1.1.1 ###
*Release Date - 2016-11-26*

* Removed unnecessary .pot file
* Fixed data validation and sanitization issues

### 1.1.0 ###
*Release Date - 2016-11-24*

* Fixed WooCommerce responsive issues

### 1.0.9 ###
*Release Date - 2016-11-24*

* Fixed text colors in the Contact section

### 1.0.8 ###
*Release Date - 2016-11-24*

* Fixed layout for the cart button
* Fixed responsive issues
* Fixed themecheck errors
* Replaced screenshot
* Improved sticky posts style
* Improved contrast on frontpage sections
* Improved padding and margin issues

### 1.0.7 ###
*Release Date - 2016-11-18*

* Fixed footer widgets color
* Fixed sections order with WordPress 4.7
* Updated travis and fixed grunt errors
* Fixed theme check errors
* Display the content on frontpage

### 1.0.6 ###
*Release Date - 2016-10-28*

* Improved colors options in customizer
* Compatibilty with the plugin YITH Woocommerce Zoom Magnifier
* Style attachment page
* Change default images ( compresed )
* Fixed responsive issues

### 1.0.5 ###
*Release Date - 2016-10-25*

* Update readme file
* Fixed WooCommerce issues
* Fixed section ordering on internal pages

### 1.0.4 ###
*Release Date - 2016-10-24*

* Improved sections order control
* Added hover effects on comments form/subscribe form
* Added show/hide controls for each section
* Allow html tags in the contact section

### 1.0.3 ###
*Release Date - 2016-10-21*

* Fixed issue with sections management
* Added style for the sidebar
* Small improvements in layout


### 1.0.2 ###
*Release Date - 2016-10-20*

* Added support for Jetpack portfolio
* Improved WooCommerce implementation
* Section Order
* Fixed small layout issues

### 1.0.1 ###
*Release Date - 2016-10-18*

* Alternative blog template
* Improved layout style
* Added option for sidebar on blog posts
* Optimize the main menu
* Improved WooCommerce layout
* Added grunt + fix all grunt errors


### 1.0.0 ###
*Release Date - 2016-10-03*

- First version

## Resources ##
### Libraries ###

* wp_bootstrap_navwalker, https://github.com/twittem/wp-bootstrap-navwalker
* Copyright 2014 Twitter, Edward McIntyre, GPL-2.0+, http://www.gnu.org/licenses/gpl-2.0.txt

* Bootstrap, http://getbootstrap.com/
* Copyright 2011-2015 Twitter, Inc, MIT License, http://www.opensource.org/licenses/MIT

* FontAwesome, http://fontawesome.io/
* Copyright 2015, Dave Gandy,
* Font Awesome licensed under SIL OFL 1.1, http://scripts.sil.org/OFL
* Code licensed under MIT License, http://www.opensource.org/licenses/MIT
* Documentation licensed under CC BY 3.0, http://creativecommons.org/licenses/by/3.0/

* Copyright 2014, liabru, MIT License, http://www.opensource.org/licenses/MIT

* Hammer.js, https://hammerjs.github.io/
* Copyright 2011-2017, Jorik Tangelder (Eight Media), MIT License, http://www.opensource.org/licenses/MIT

* Animate on scroll.js, https://hammerjs.github.io/
* Copyright (c) 2015 Michał Sajnóg, MIT License, http://www.opensource.org/licenses/MIT

* WordPress Plugin Boilerplate, https://github.com/DevinVinson/WordPress-Plugin-Boilerplate
* Copyright (C) 1989, 1991 Free Software Foundation, GPL-2.0

* Parallax.js, https://github.com/wagerfield/parallax
* Matthew Wagerfield, René Roth, MIT License, http://www.opensource.org/licenses/MIT

### Images ###


* Hestia: 1.jpg, CC0, https://mystock.themeisle.com/photo/girl/
* Hestia: 2.jpg, CC0, https://mystock.themeisle.com/photo/winter-hat/

* Hestia Default: tropical-beach, CC0, https://mystock.themeisle.com/photo/tropical-beach/


All images are licensed under CC0.

Screenshot resources:

* https://mystock.themeisle.com/photo/mountain/

Starter Sites screenshots resources:

WooCommerce

* https://mystock.themeisle.com/photo/sunflower/
* https://mystock.themeisle.com/photo/flower/
* https://mystock.themeisle.com/photo/blooming-bougainvillea-flowers/
* https://mystock.themeisle.com/photo/flower-buds/
* https://mystock.themeisle.com/photo/rock-flowers/
* https://mystock.themeisle.com/photo/mountain-flowers/
* http://mystock.themeisle.com/photo/lilac/

Energy Panels

* https://stocksnap.io/photo/J5Z48RFO76
* https://stocksnap.io/photo/QEUHCFGQNP
* https://stocksnap.io/photo/WVKCUPH3RC
* https://stocksnap.io/photo/KAUFJW1PEQ

Vet Center

* https://stocksnap.io/photo/GSBJXWRSDV

Agency Travel

* https://mystock.themeisle.com/photo/amsterdam/

Lawyers

* https://mystock.themeisle.com/photo/liberty-in-shadow/